package gov.va.med.mhv.getcare.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.mhv.common.api.cache.CacheHandler;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.transfer.Session;
import gov.va.med.mhv.getcare.common.dto.AppointmentDTO;
import gov.va.med.mhv.getcare.converter.AppointmentConverter;
import gov.va.med.mhv.getcare.model.Appointment;
import gov.va.med.mhv.getcare.repository.AppointmentRepository;
import gov.va.med.mhv.getcare.service.AppointmentService;
import gov.va.med.mhv.usermgmt.service.AccountActivityLogService;

@Component
public class AppointmentServiceImpl  implements AppointmentService {
	
	private static Logger log = LogManager.getLogger(AppointmentServiceImpl.class);
	
	@Autowired
	private AppointmentRepository appointmentRepository;
	
	@Resource
	private AccountActivityLogService activityServiceProxy;
	
	
	@Override
	@Transactional
	public List<AppointmentDTO> findAppointmentsForPatient(Long patientid,Boolean recordAAL) throws MHVException {
		List<AppointmentDTO> dtos = null;
		Session session = CacheHandler.getInstance().getSession();
		Long userProfileId = session.getUserId();
		List<Appointment> appointments = appointmentRepository.getAppointmentsForPatient(patientid);
		if(recordAAL){
	 	  activityServiceProxy.auditViewAppointments(userProfileId);
		}
		if (appointments != null) {
			dtos = AppointmentConverter.convertAppoinmentRecords(appointments);
		} else {
			log.debug("Allergy Records not found for PatientId:");
			log.debug(patientid);
		}
		
		return dtos;
	}
}
